﻿<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=0">

    <title>Modular Laboratory Furniture</title>

    <!-- Fav Icon -->
    <link rel="icon" href="assets/images/favicon.ico" type="image/x-icon">

    <!-- Google Fonts -->
    <link href="../css2?family=Afacad:ital,wght@0,400;0,500;0,600;0,700;1,400;1,500;1,600;1,700&display=swap"
        rel="stylesheet">
    <link href="../css2-1?family=Inter:wght@100;200;300;400;500;600;700;800;900&display=swap" rel="stylesheet">

    <!-- Stylesheets -->
    <link href="assets/css/font-awesome-all.css" rel="stylesheet">
    <link href="assets/css/flaticon.css" rel="stylesheet">
    <link href="assets/css/owl.css" rel="stylesheet">
    <link href="assets/css/bootstrap.css" rel="stylesheet">
    <link href="assets/css/jquery.fancybox.min.css" rel="stylesheet">
    <link href="assets/css/animate.css" rel="stylesheet">
    <link href="assets/css/nice-select.css" rel="stylesheet">
    <link href="assets/css/elpath.css" rel="stylesheet">
    <link href="assets/css/color/theme-color.css" id="jssDefault" rel="stylesheet">
    <link href="assets/css/switcher-style.css" rel="stylesheet">
    <link href="assets/css/odometer.css" rel="stylesheet">
    <link href="assets/css/rtl.css" rel="stylesheet">
    <link href="assets/css/style.css" rel="stylesheet">
    <link href="assets/css/module-css/page-title.css" rel="stylesheet">
    <link href="assets/css/module-css/service-details.css" rel="stylesheet">
    <link href="assets/css/module-css/service-sidebar.css" rel="stylesheet">
    <link href="assets/css/module-css/service.css" rel="stylesheet">
    <link href="assets/css/module-css/faq.css" rel="stylesheet">
    <link href="assets/css/module-css/cta.css" rel="stylesheet">
    <link href="assets/css/responsive.css" rel="stylesheet">
    <style>
        h4 {
           color: #fbbf18;
           margin-bottom: 15px;
        }
    </style>

</head>


<!-- page wrapper -->

<body>

    <div class="boxed_wrapper ltr">

        <!-- Header  -->
        <?php include('inc/header.php'); ?>
        <!-- main-header end -->


        <!-- main-content -->
        <main class="main-content alternat-2">
            <!-- page-title -->
            <section class="page-title centred">
                <div class="bg-layer" style="background-image: url(assets/images/background/modular-furniture.png);">
                </div>
                <div class="pattern-layer" style="background-image: url(assets/images/shape/shape-53.png);"></div>
                <div class="auto-container">
                    <div class="content-box">
                        <h2>Modular Laboratory Furniture</h2>
                        <ul class="bread-crumb">
                            <li><a href="index.php">Home</a></li>
                            <li>-</li>
                            <li>Modular Laboratory Furniture</li>
                        </ul>
                    </div>
                </div>
            </section>
            <!-- page-title end -->


            <!-- service-details -->
            <section class="pt_80">
                <div class="auto-container">
                    <div class="row clearfix">
                        <div class="col-lg-4 col-md-12 col-sm-12 sidebar-side">
                            <div class="service-sidebar mr_20">
                                <div class="category-widget sidebar-widget mb_30">
                                    <div class="widget-title mb_12">
                                        <h3>Our Services</h3>
                                    </div>
                                    <div class="widget-content">
                                        <ul class="category-list clearfix">
                                            <li><a href="about.php">Bio-Safety Cabinet</a></li>
                                            <li><a href="laminar-air-flow.php">Laminar Air Flow</a></li>
                                            <li><a href="modular-laboratory-furniture.php" class="current">Modular
                                                    Laboratory Furniture</a></li>
                                            <li><a href="new-age-fume-cupboard.php">New Age Fume Cupboard</a></li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-8 col-md-12 col-sm-12 content-side">
                            <div class="service-details-content">
                                <div class="content-one mb_65">
                                    <div class="text-box mb_35">
                                        <h2>Modular Laboratory Furniture – Zigma</h2><strong class="fs_18">Innovation
                                            Meets Functionality</strong>
                                        <p>Labex introduces Zigma, a next-generation modular laboratory furniture system
                                            designed to optimize space, enhance functionality, and ensure compliance
                                            with global safety standards. Engineered for flexibility, durability, and
                                            ease of installation, Zigma is the perfect solution for modern laboratories
                                            across pharmaceuticals, biotechnology, healthcare, research, and industrial
                                            applications.</p>
                                    </div>
                                    <figure class="image-box mb_35"><img
                                            src="assets/images/service/modular-laboratory-furniture.jpg" alt=""
                                            width="100%">
                                    </figure>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="auto-container">
                        <div class="row clearfix">
                            <div class="col-lg-12 col-md-12 col-sm-12 content-side">
                                <div class="service-details-content">
                                    <div class="text-box mb_30">
                                        <h4>Key Features of Zigma Modular Laboratory Furniture</h4>
                                        <div class="row mb-3">
                                            <div class="col-lg-6 mt-3">
                                                <ul class="list-item clearfix">
                                                    <h5>1. Customizable Configurations</h5>
                                                    <li> Tailor-made designs to suit diverse lab requirements</li>
                                                    <li> Modular units for easy reconfiguration and expansion</li>
                                                    <li> Various sizes and layouts to maximize efficiency</li>
                                                </ul>
                                            </div>
                                            <div class="col-lg-6 mt-3">
                                                <ul class="list-item clearfix">
                                                    <h5>2. Ergonomic and Aesthetic Design</h5>
                                                    <li> User-friendly workspaces for maximum comfort and productivity
                                                    </li>
                                                    <li> Sleek, modern finishes with a choice of colors</li>
                                                    <li> Smart storage solutions for optimal space utilization</li>
                                                </ul>
                                            </div>
                                            <div class="col-lg-6 mt-3">
                                                <ul class="list-item clearfix">
                                                    <h5>3. Compliance with Global Standards</h5>
                                                    <li> Designed to meet USFDA, WHO, GMP, ISO, and SEFA standards</li>
                                                    <li> Certified for cleanroom and sterile environments</li>
                                                    <li> Integrated safety features for controlled lab operations</li>

                                                </ul>
                                            </div>
                                            <div class="col-lg-6 mt-3">
                                                <ul class="list-item clearfix">
                                                    <h5>4. Integrated Utility Management</h5>
                                                    <li> Provision for gas, electrical, and data connectivity</li>
                                                    <li> Built-in ventilation and fume extraction options</li>
                                                    <li> Water-resistant and easy-to-clean surfaces for contamination
                                                        control</li>

                                                </ul>
                                            </div>
                                            <div class="col-lg-6 mt-3">
                                                <ul class="list-item clearfix">
                                                    <h5>5. Premium-Quality Materials</h5>
                                                    <li> Chemical-resistant surfaces for enhanced durability</li>
                                                    <li>Anti-corrosive stainless steel, powder-coated steel, or
                                                        high-pressure
                                                        laminate options</li>
                                                    <li>Fire-retardant materials for added safety</li>
                                                </ul>
                                            </div>
                                        </div>
                                        

                                        <div class="text-box mb_30">
                                            <h4>Applications</h4>
                                            <ul class="list-item clearfix">
                                                <li> Pharmaceutical & Biotech Labs</li>
                                                <li> R&D Laboratories</li>
                                                <li> Healthcare & Diagnostic Centers</li>
                                                <li> Educational & Institutional Laboratories</li>
                                                <li> Industrial Testing & Quality Control Labs</li>
                                            </ul>
                                        </div>

                                        <div class="text-box mb_30">
                                            <h4>Why Choose Zigma by Labex?</h4>
                                            <ul class="list-item clearfix">
                                                <li><b>Scalability –</b> Future-ready design adaptable to evolving
                                                    needs</li>
                                                <li><b>Durability –</b> Long-lasting, high-performance materials</li>
                                                <li><b>Cost-Effective –</b> Modular approach reduces long-term costs
                                                </li>
                                                <li><b>Hassle-Free Installation –</b> Quick assembly with minimal
                                                    disruption
                                                </li>
                                                <li><b>Sustainable Design –</b> Eco-friendly materials and
                                                    energy-efficient manufacturing
                                                </li>
                                            </ul>
                                            <p class="mt-4">Transform your laboratory with <b>Zigma Modular Laboratory
                                                    Furniture</b>
                                                by
                                                Labex – where precision, innovation, and efficiency converge.</p>
                                        </div>
                                    </div>

                                    <div class="text-box mb_30">
                                        <h5>For more details, contact us today <a href="tel:+91 86556 02939">+91 86556 02939</a></h5>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
            <!-- service-details end -->
        </main>
        <!-- main-content end -->


        <!-- main-footer -->
        <?php include('inc/footer.php'); ?>
        <!-- main-footer end -->



        <!--Scroll to top-->
        <div class="scroll-to-top">
            <svg class="scroll-top-inner" viewbox="-1 -1 102 102">
                <path d="M50,1 a49,49 0 0,1 0,98 a49,49 0 0,1 0,-98"></path>
            </svg>
        </div>

    </div>


    <!-- jequery plugins -->
    <script src="assets/js/jquery.js"></script>
    <script src="assets/js/bootstrap.min.js"></script>
    <script src="assets/js/owl.js"></script>
    <script src="assets/js/wow.js"></script>
    <script src="assets/js/validation.js"></script>
    <script src="assets/js/jquery.fancybox.js"></script>
    <script src="assets/js/appear.js"></script>
    <script src="assets/js/isotope.js"></script>
    <script src="assets/js/parallax-scroll.js"></script>
    <script src="assets/js/jquery.nice-select.min.js"></script>
    <script src="assets/js/jQuery.style.switcher.min.js"></script>
    <script src="assets/js/language.js"></script>
    <script src="assets/js/scrolltop.min.js"></script>
    <script src="assets/js/gsap.js"></script>
    <script src="assets/js/ScrollTrigger.js"></script>
    <script src="assets/js/SplitText.js"></script>
    <script src="assets/js/odometer.js"></script>
    <script src="assets/js/particles.min.js"></script>
    <script src="assets/js/particles-config.js"></script>

    <!-- main-js -->
    <script src="assets/js/script.js"></script>

</body><!-- End of .page_wrapper -->

</html>