﻿<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=0">

    <title>Laminar Air Flow</title>

    <!-- Fav Icon -->
    <link rel="icon" href="assets/images/favicon.ico" type="image/x-icon">

    <!-- Google Fonts -->
    <link href="../css2?family=Afacad:ital,wght@0,400;0,500;0,600;0,700;1,400;1,500;1,600;1,700&display=swap"
        rel="stylesheet">
    <link href="../css2-1?family=Inter:wght@100;200;300;400;500;600;700;800;900&display=swap" rel="stylesheet">

    <!-- Stylesheets -->
    <link href="assets/css/font-awesome-all.css" rel="stylesheet">
    <link href="assets/css/flaticon.css" rel="stylesheet">
    <link href="assets/css/owl.css" rel="stylesheet">
    <link href="assets/css/bootstrap.css" rel="stylesheet">
    <link href="assets/css/jquery.fancybox.min.css" rel="stylesheet">
    <link href="assets/css/animate.css" rel="stylesheet">
    <link href="assets/css/nice-select.css" rel="stylesheet">
    <link href="assets/css/elpath.css" rel="stylesheet">
    <link href="assets/css/color/theme-color.css" id="jssDefault" rel="stylesheet">
    <link href="assets/css/switcher-style.css" rel="stylesheet">
    <link href="assets/css/odometer.css" rel="stylesheet">
    <link href="assets/css/rtl.css" rel="stylesheet">
    <link href="assets/css/style.css" rel="stylesheet">
    <link href="assets/css/module-css/page-title.css" rel="stylesheet">
    <link href="assets/css/module-css/service-details.css" rel="stylesheet">
    <link href="assets/css/module-css/service-sidebar.css" rel="stylesheet">
    <link href="assets/css/module-css/service.css" rel="stylesheet">
    <link href="assets/css/module-css/faq.css" rel="stylesheet">
    <link href="assets/css/module-css/cta.css" rel="stylesheet">
    <link href="assets/css/responsive.css" rel="stylesheet">
    <style>
        h4 {
           color: #fbbf18;
           margin-bottom: 15px;
        }
    </style>

</head>


<!-- page wrapper -->

<body>

    <div class="boxed_wrapper ltr">

        <!-- Header  -->
        <?php include('inc/header.php'); ?>
        <!-- main-header end -->


        <!-- main-content -->
        <main class="main-content alternat-2">
            <!-- page-title -->
            <section class="page-title centred">
                <div class="bg-layer" style="background-image: url(assets/images/background/laminar-air-flow.png);">
                </div>
                <div class="pattern-layer" style="background-image: url(assets/images/shape/shape-53.png);"></div>
                <div class="auto-container">
                    <div class="content-box">
                        <h2>Laminar Air Flow</h2>
                        <ul class="bread-crumb">
                            <li><a href="index.php">Home</a></li>
                            <li>-</li>
                            <li>Laminar Air Flow</li>
                        </ul>
                    </div>
                </div>
            </section>
            <!-- page-title end -->


            <!-- service-details -->
            <section class="pt_80">
                <div class="auto-container">
                    <div class="row clearfix">
                        <div class="col-lg-4 col-md-12 col-sm-12 sidebar-side">
                            <div class="service-sidebar mr_20">
                                <div class="category-widget sidebar-widget mb_30">
                                    <div class="widget-title mb_12">
                                        <h3>Our Services</h3>
                                    </div>
                                    <div class="widget-content">
                                        <ul class="category-list clearfix">
                                            <li><a href="about.php">Bio-Safety Cabinet</a></li>
                                            <li><a href="laminar-air-flow.php" class="current">Laminar Air Flow</a></li>
                                            <li><a href="modular-laboratory-furniture.php">Modular Laboratory
                                                    Furniture</a></li>
                                            <li><a href="new-age-fume-cupboard.php">New Age Fume Cupboard</a></li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-8 col-md-12 col-sm-12 content-side">
                            <div class="service-details-content">
                                <div class="content-one mb_65">
                                    <div class="text-box mb_35">
                                        <h2>Laminar Air Flow (LAF) -</h2><strong class="fs_18">Precision Air
                                            Purification for Laboratories</strong>
                                        <p>Labex Laminar Air Flow (LAF) systems are designed to provide a clean and
                                            particle-free working environment by directing filtered air in a
                                            unidirectional flow. Equipped with high-efficiency particulate air (HEPA)
                                            filtration, our LAF units ensure the highest level of contamination control,
                                            making them essential for research, pharmaceutical, and industrial
                                            applications.</p>
                                    </div>
                                    <figure class="image-box mb_35"><img
                                            src="assets/images/service/laminar-air-flow.jpg" alt="" width="100%">
                                    </figure>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="auto-container">
                        <div class="row clearfix">
                            <div class="col-lg-12 col-md-12 col-sm-12 content-side">
                                <div class="service-details-content">
                                    <div class="text-box mb_30">
                                        <h4>Key Features</h4>
                                        <ul class="list-item clearfix">
                                            <li><b>HEPA/ULPA Filtration:</b> Removes 99.99% of airborne contaminants
                                                at 0.3 microns for optimal sterility.</li>
                                            <li><b>Unidirectional Airflow:</b> Ensures uniform, controlled air movement,
                                                preventing cross-contamination.</li>
                                            <li><b>Ergonomic & Robust Design:</b> Constructed with high-quality
                                                stainless steel for durability and easy maintenance.</li>
                                            <li><b>Energy-Efficient & Low Noise:</b> Designed for continuous operation
                                                with minimal energy consumption.</li>
                                            <li><b>User-Friendly Interface:</b> Digital controls with real-time
                                                monitoring of airflow and filter life.</li>
                                            <li><b>Safety Features:</b> UV sterilization, alarms for airflow disruption,
                                                and optional customization.</li>
                                        </ul>
                                    </div>
                                    <div class="text-box mb_30">
                                        <h4>Applications</h4>
                                        <ul class="list-item clearfix">
                                            <li><b>Pharmaceutical & Biotechnology Laboratories:</b> Protecting
                                                sensitive product handling processes.</li>
                                            <li><b>Microbiology & Research Labs:</b> Ensuring aseptic conditions for
                                                sample analysis.</li>
                                            <li><b>Electronics & Semiconductor Manufacturing:</b> Preventing particulate
                                                contamination during assembly.</li>
                                            <li><b>Food & Beverage Industry:</b> Maintaining sterile conditions in
                                                quality control procedures.</li>
                                        </ul>
                                    </div>
                                    <div class="text-box mb_30">
                                        <h4>Types of Laminar Air Flow Systems</h4>
                                        <ul class="list-item clearfix">
                                            <li><b>Horizontal LAF:</b> Air flows parallel to the work surface, ideal for
                                                processes requiring minimal turbulence.</li>
                                            <li><b>Vertical LAF:</b> Air flows downward, suitable for applications
                                                requiring enhanced protection against airborne particles.</li>
                                            <li><b>Customized LAF Solutions:</b> Tailored designs to meet specific
                                                laboratory or industrial requirements.</li>
                                        </ul>
                                    </div>
                                    <div class="text-box mb_30">
                                        <h4>Why Choose Labex Laminar Air Flow?</h4>
                                        <ul class="list-item clearfix">
                                            <li>Compliance with international standards (ISO 14644-1, USP 797, GMP).
                                            </li>
                                            <li>Customizable configurations for diverse industry applications.</li>
                                            <li>Precision-engineered for high-performance and reliability.</li>
                                            <li>Comprehensive after-sales support & maintenance.</li>
                                        </ul>
                                    </div>
                                    <div class="text-box mb_30">
                                        <h5>For more details, contact us today <a href="tel:+91 86556 02939">+91 86556 02939</a></h5>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
            <!-- service-details end -->
        </main>
        <!-- main-content end -->


        <!-- main-footer -->
        <?php include('inc/footer.php'); ?>
        <!-- main-footer end -->



        <!--Scroll to top-->
        <div class="scroll-to-top">
            <svg class="scroll-top-inner" viewbox="-1 -1 102 102">
                <path d="M50,1 a49,49 0 0,1 0,98 a49,49 0 0,1 0,-98"></path>
            </svg>
        </div>

    </div>


    <!-- jequery plugins -->
    <script src="assets/js/jquery.js"></script>
    <script src="assets/js/bootstrap.min.js"></script>
    <script src="assets/js/owl.js"></script>
    <script src="assets/js/wow.js"></script>
    <script src="assets/js/validation.js"></script>
    <script src="assets/js/jquery.fancybox.js"></script>
    <script src="assets/js/appear.js"></script>
    <script src="assets/js/isotope.js"></script>
    <script src="assets/js/parallax-scroll.js"></script>
    <script src="assets/js/jquery.nice-select.min.js"></script>
    <script src="assets/js/jQuery.style.switcher.min.js"></script>
    <script src="assets/js/language.js"></script>
    <script src="assets/js/scrolltop.min.js"></script>
    <script src="assets/js/gsap.js"></script>
    <script src="assets/js/ScrollTrigger.js"></script>
    <script src="assets/js/SplitText.js"></script>
    <script src="assets/js/odometer.js"></script>
    <script src="assets/js/particles.min.js"></script>
    <script src="assets/js/particles-config.js"></script>

    <!-- main-js -->
    <script src="assets/js/script.js"></script>

</body><!-- End of .page_wrapper -->

</html>