﻿<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=0">

    <title>Bio-Safety Cabinet</title>

    <!-- Fav Icon -->
    <link rel="icon" href="assets/images/favicon.ico" type="image/x-icon">

    <!-- Google Fonts -->
    <link href="../css2?family=Afacad:ital,wght@0,400;0,500;0,600;0,700;1,400;1,500;1,600;1,700&display=swap"
        rel="stylesheet">
    <link href="../css2-1?family=Inter:wght@100;200;300;400;500;600;700;800;900&display=swap" rel="stylesheet">

    <!-- Stylesheets -->
    <link href="assets/css/font-awesome-all.css" rel="stylesheet">
    <link href="assets/css/flaticon.css" rel="stylesheet">
    <link href="assets/css/owl.css" rel="stylesheet">
    <link href="assets/css/bootstrap.css" rel="stylesheet">
    <link href="assets/css/jquery.fancybox.min.css" rel="stylesheet">
    <link href="assets/css/animate.css" rel="stylesheet">
    <link href="assets/css/nice-select.css" rel="stylesheet">
    <link href="assets/css/elpath.css" rel="stylesheet">
    <link href="assets/css/color/theme-color.css" id="jssDefault" rel="stylesheet">
    <link href="assets/css/switcher-style.css" rel="stylesheet">
    <link href="assets/css/odometer.css" rel="stylesheet">
    <link href="assets/css/rtl.css" rel="stylesheet">
    <link href="assets/css/style.css" rel="stylesheet">
    <link href="assets/css/module-css/page-title.css" rel="stylesheet">
    <link href="assets/css/module-css/service-details.css" rel="stylesheet">
    <link href="assets/css/module-css/service-sidebar.css" rel="stylesheet">
    <link href="assets/css/module-css/service.css" rel="stylesheet">
    <link href="assets/css/module-css/faq.css" rel="stylesheet">
    <link href="assets/css/module-css/cta.css" rel="stylesheet">
    <link href="assets/css/responsive.css" rel="stylesheet">
    <style>
        h4 {
           color: #fbbf18;
           margin-bottom: 15px;
        }
    </style>

</head>


<!-- page wrapper -->

<body>

    <div class="boxed_wrapper ltr">

        <!-- Header  -->
        <?php include('inc/header.php'); ?>
        <!-- main-header end -->


        <!-- main-content -->
        <main class="main-content alternat-2">
            <!-- page-title -->
            <section class="page-title centred">
                <div class="bg-layer" style="background-image: url(assets/images/background/bio-safety-cabinet.png);">
                </div>
                <div class="pattern-layer" style="background-image: url(assets/images/shape/shape-53.png);"></div>
                <div class="auto-container">
                    <div class="content-box">
                        <h2>Bio-Safety Cabinet</h2>
                        <ul class="bread-crumb">
                            <li><a href="index.php">Home</a></li>
                            <li>-</li>
                            <li>Bio-Safety Cabinet</li>
                        </ul>
                    </div>
                </div>
            </section>
            <!-- page-title end -->


            <!-- service-details -->
            <section class="pt_80">
                <div class="auto-container">
                    <div class="row clearfix">
                        <div class="col-lg-4 col-md-12 col-sm-12 sidebar-side">
                            <div class="service-sidebar mr_20">
                                <div class="category-widget sidebar-widget mb_30">
                                    <div class="widget-title mb_12">
                                        <h3>Our Services</h3>
                                    </div>
                                    <div class="widget-content">
                                        <ul class="category-list clearfix">
                                            <li><a href="service.php" class="current">Bio-Safety Cabinet</a></li>
                                            <li><a href="laminar-air-flow.php">Laminar Air Flow</a></li>
                                            <li><a href="modular-laboratory-furniture.php">Modular Laboratory
                                                    Furniture</a></li>
                                            <li><a href="new-age-fume-cupboard.php">New Age Fume Cupboard</a></li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-8 col-md-12 col-sm-12 content-side">
                            <div class="service-details-content">
                                <div class="content-one mb_65">
                                    <div class="text-box mb_35">
                                        <h2>Bio-Safety Cabinet (BSC) -</h2><strong class="fs_18">Ensuring Safety &
                                            Contamination Control</strong>
                                        <p>Labex Bio-Safety Cabinets (BSC) are designed to provide a controlled,
                                            sterile, and safe environment for handling hazardous biological materials.
                                            Engineered with advanced airflow technology and high-efficiency particulate
                                            air (HEPA) filtration, our BSCs offer superior protection for personnel,
                                            product, and the surrounding environment.</p>
                                    </div>
                                    <figure class="image-box mb_35"><img
                                            src="assets/images/service/bio-safety-cabinet.jpg" alt="" width="100%">
                                    </figure>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="auto-container">
                        <div class="row clearfix">
                            <div class="col-lg-12 col-md-12 col-sm-12 content-side">
                                <div class="service-details-content">
                                    <div class="text-box mb_30">
                                        <h4>Key Features</h4>
                                        <ul class="list-item clearfix">
                                            <li><b>HEPA Filtration System:</b> Removes airborne contaminants with 99.99%
                                                efficiency at 0.3 microns, ensuring a sterile workspace.</li>
                                            <li><b>Advanced Airflow Design:</b> Maintains laminar airflow and prevents
                                                cross-contamination.</li>
                                            <li><b>Ergonomic & Durable Construction:</b> Made with high-quality
                                                stainless steel for easy cleaning and long-lasting performance.</li>
                                            <li><b>Energy-Efficient Operation:</b> Low-noise, low-energy consumption for
                                                sustainable use.</li>
                                            <li><b>User-Friendly Controls:</b> Digital display with real-time monitoring
                                                of airflow and filter life.</li>
                                            <li><b>Safety Mechanisms:</b> UV sterilization, audible alarms for airflow
                                                disruption, and front sash protection.</li>
                                        </ul>
                                    </div>
                                    <div class="text-box mb_30">
                                        <h4>Applications</h4>
                                        <ul class="list-item clearfix">
                                            <li><b>Microbiology & Research Laboratories:</b> Handling pathogens and
                                                biohazardous materials.</li>
                                            <li><b>Pharmaceutical & Biotechnology Industries:</b> Ensuring
                                                contamination-free product handling.</li>
                                            <li><b>Hospitals & Clinical Settings:</b> Protecting healthcare
                                                professionals from infectious samples.</li>
                                            <li><b>Food & Beverage Testing:</b> Maintaining sterility in sample
                                                processing.</li>
                                        </ul>
                                    </div>
                                    <div class="text-box mb_30">
                                        <h4>Types of Bio-Safety Cabinets</h4>
                                        <ul class="list-item clearfix">
                                            <li><b>Class I BSC:</b> Protects personnel and environment; suitable for
                                                low-to-moderate risk biological agents.</li>
                                            <li><b>Class II BSC (Type A2 & B2):</b> Provides personnel, product, and
                                                environmental protection; widely used in pharmaceutical and research
                                                laboratories.</li>
                                            <li><b>Class III BSC:</b> Maximum containment for high-risk pathogens,
                                                designed for BSL-3 and BSL-4 laboratories.</li>
                                        </ul>
                                    </div>
                                    <div class="text-box mb_30">
                                        <h4>Why Choose Labex Bio-Safety Cabinets?</h4>
                                        <ul class="list-item clearfix">
                                            <li>Compliance with international safety standards (EN 12469, NSF/ANSI 49,
                                                ISO 14644-1).</li>
                                            <li>Customizable designs tailored to specific lab requirements.</li>
                                            <li>Reliable performance backed by rigorous quality testing.</li>
                                            <li>Comprehensive after-sales support & service.</li>
                                        </ul>
                                    </div>
                                    <div class="text-box mb_30">
                                        <h5>For more details, contact us today <a href="tel:+91 86556 02939">+91 86556 02939</a></h5>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
            <!-- service-details end -->
        </main>
        <!-- main-content end -->


        <!-- main-footer -->
        <?php include('inc/footer.php'); ?>
        <!-- main-footer end -->



        <!--Scroll to top-->
        <div class="scroll-to-top">
            <svg class="scroll-top-inner" viewbox="-1 -1 102 102">
                <path d="M50,1 a49,49 0 0,1 0,98 a49,49 0 0,1 0,-98"></path>
            </svg>
        </div>

    </div>


    <!-- jequery plugins -->
    <script src="assets/js/jquery.js"></script>
    <script src="assets/js/bootstrap.min.js"></script>
    <script src="assets/js/owl.js"></script>
    <script src="assets/js/wow.js"></script>
    <script src="assets/js/validation.js"></script>
    <script src="assets/js/jquery.fancybox.js"></script>
    <script src="assets/js/appear.js"></script>
    <script src="assets/js/isotope.js"></script>
    <script src="assets/js/parallax-scroll.js"></script>
    <script src="assets/js/jquery.nice-select.min.js"></script>
    <script src="assets/js/jQuery.style.switcher.min.js"></script>
    <script src="assets/js/language.js"></script>
    <script src="assets/js/scrolltop.min.js"></script>
    <script src="assets/js/gsap.js"></script>
    <script src="assets/js/ScrollTrigger.js"></script>
    <script src="assets/js/SplitText.js"></script>
    <script src="assets/js/odometer.js"></script>
    <script src="assets/js/particles.min.js"></script>
    <script src="assets/js/particles-config.js"></script>

    <!-- main-js -->
    <script src="assets/js/script.js"></script>

</body><!-- End of .page_wrapper -->

</html>